	PAGE 60,132
	TITLE	EGAFUN
;==========================================================================
; 
; EGAFUN - EGA GRAPHICS ROUTINES
;
; C. Davis 19/03/87
;
;==========================================================================

	comment	|

The functions provided are as follows


 1) PLOT A HORIZONTAL RUN OF BYTES TO A COLOUR PLANE OF 640x350 GRAPHICS

	Synopsis: char* egarun(off,pat,cnt,pln,op,p);

	char *off	offset within scr page to first byte
	char pat	pattern mask for bytes
	int  cnt	byte count to plot
	int  pln	colour plane to write:
				1=	blue
				2=	green
				4=	red
				8=	intensity
	int op		screen operation performed:
				0=	  MOV (destructive write)
				0x10= OR (non-destructive write)
				other ops, AND= 8 and XOR= 0x18
				are also supported
	int p		EGA screen page, 0 or 1

	|
;--------------------------------------------------------------------------
; System equates
;
gdc	equ	03ceh	;port addr of Graphics Data Controller

; GDC registers

gdcmask	equ	8 	; mask reg
gdcalu	equ	3	; ALU reg
gdcset	equ	0	; set reg
gdcenab	equ	1	; enable reg

; Misc.

egaseg	equ	0a000h	; screen ram segment
pg2off	equ	0800h	; ram offset to pg 2

;--------------------------------------------------------------------------
; SEG DEFINITIONS for MS C 4.0
;
CODE	SEGMENT	BYTE PUBLIC
CODE	ENDS

DATA	SEGMENT	WORD PUBLIC
DATA	ENDS

DGROUP	GROUP DATA
	ASSUME	CS:CODE,DS:DGROUP,SS:DGROUP,ES:DGROUP

;--------------------------------------------------------------------------
;
; Stack structure at plot call entry
;
;	Synopsis: char* egarun(off,pat,cnt,pln,op,p);

rpstack	struc

	dw	?	; callers bp

	dw	?	; return addr

 pg	dw	?	; EGA screen page
 op	db	?	; logical pixel operation code
 	db	?	; hi byte
 pln	db	?	; colour plane to write
 	db	?	; hi byte
 cnt	dw	?	; count of bytes to write
 pat	db	?	; pixel pattern to write
 	db	?
 off	dw	?	; offset addr within EGA screen seg

rpstack	ends

;
;--------------------------------------------------------------------------
CODE	SEGMENT
;--------------------------------------------------------------------------

egarun	proc	near

	public	egarun


	push	bp
	mov	bp,sp

	push	di
	push	si
	push	es

	mov	dx,gdc			; get GDC port addr

	mov	ah,[bp].pat		; get pattern
	mov	al,gdcmask		; & reg
	out	dx,ax			; send it

	mov	ah,[bp].op		; get operation
	mov	al,gdcalu		;  & reg
	out	dx,ax

	mov	ah,[bp].pln		; get plane
	mov	al,gdcset
	out	dx,ax

	mov	ah,0fh			; enable the planes
	mov	al,gdcenab
	out	dx,ax

	mov	ax,egaseg		; point ES to EGA pg 1
	test	[bp].pg,1		; page 2 wanted?
	jz	er2			; no
	add	ax,pg2off		; ofset to pg 2

er2:	mov	es,ax

	mov	di,[bp].off		; point to pixel byte
	mov	cx,[bp].cnt		; get count
	jcxz	er4			; no 'count sumbitch
	xor	al,al			; make a zilch to store

er3:	mov	ah,es:[di]		; latch the byte to GDC
	stosb	   			; write byte back
	loop	er3			; do next byte

er4:	mov	ah,0ffh			; restore mask
	mov	al,gdcmask
	out	dx,ax

	mov	ax,di			; get new offset as return val

	pop	es			; restore regs
	pop	si
	pop	di
	pop	bp

	ret	 12

egarun	endp

;--------------------------------------------------------------------------

CODE	ENDS
	END
;==========================================================================



